import { Cardinal } from './../modules/directions.js';
import { Tool } from './base_tool.js';
import { Tools } from './tool_manager.js';
class StackerTool extends Tool {
    constructor(range, mask) {
        super();
        this.permission = 'worldedit.region.stack';
        this.useOn = function (self, player, session, loc) {
            const dim = player.dimension;
            const dir = new Cardinal(Cardinal.Dir.BACK).getDirection(player);
            const start = loc.offset(dir.x, dir.y, dir.z);
            if (!this.mask.matchesBlock(start, dim)) {
                return;
            }
            let end = loc;
            for (var i = 0; i < this.range; i++) {
                end = end.offset(dir.x, dir.y, dir.z);
                if (!this.mask.matchesBlock(end.offset(dir.x, dir.y, dir.z), dim))
                    break;
            }
            const history = session.getHistory();
            const record = history.record();
            const tempStack = session.createRegion(true);
            try {
                history.addUndoStructure(record, start, end, 'any');
                tempStack.save(loc, loc, dim);
                for (const pos of start.blocksBetween(end)) {
                    tempStack.load(pos, dim);
                }
                history.addRedoStructure(record, start, end, 'any');
                history.commit(record);
            }
            catch (e) {
                history.cancel(record);
                throw e;
            }
            finally {
                session.deleteRegion(tempStack);
            }
        };
        this.range = range;
        this.mask = mask;
    }
}
Tools.register(StackerTool, 'stacker_wand');
